; #============================================================================================================================================================
; Title .........: FindPixel v1.4
; AutoIt Version : 3.3.14.2
; Description ...: Functions for fast pixel search.
; =============================================================================================================================================================

; #CONSTANTS# =================================================================================================================================================
Global Const $Dll_name = 'FindPixel.dll'
; =============================================================================================================================================================

; #DLL OPEN# =================================================================================================================================================
OpenFPDll()
Func OpenFPDll()
	Global $FP_Dll = -1
	$FP_Dll = DllOpen($Dll_name)
	If $FP_Dll = -1 Then
		MsgBox(0, 'Error', 'Failed to load '&$Dll_name&'. Check if the file '&$Dll_name&' is installed near this script.')
		Exit(1)
	EndIf
EndFunc
; =============================================================================================================================================================


; #FUNCTION# ==================================================================================================================================================
Func _FPFindAllPixel($X0, $Y0, $Width, $Height, $Color, $Shade, $Step)
	$Result = DllCall($FP_Dll, 'int', 'FindPixel_Buff_ToArr', 'int', $X0, 'int', $Y0, 'int', $Width, 'int', $Height, 'int', $Color, 'int', $Shade, 'int', $Step)
	If @error Or  $Result[0] == -1 Then Return SetError(1, 0, -1)

	If $Result[0] == -2 Then $Result[0] = 0
	Return $Result[0] ; Success: returns the number of pixels
EndFunc

; #FUNCTION# ==================================================================================================================================================
Func _FPFindPixel($X0, $Y0, $Width, $Height, $Color, $Shade, $Step)
    $Result = DllCall($FP_Dll, 'int', 'FindPixel_Buff', 'int', $X0, 'int', $Y0, 'int', $Width, 'int', $Height, 'int', $Color, 'int', $Shade, 'int', $Step)
    If @error Or  $Result[0] == -1 Then Return SetError(1, 0, -1)
	If $Result[0] == -2 Then Return $Result[0]

	Local $aPosition[2]
	$aPosition[0] = BitAND($Result[0], 0xFFFF)
	$aPosition[1] = BitAND(BitShift($Result[0], 16), 0xFFFF)
    Return $aPosition ; Success: returns the array of pixel coordinates or "-2" if pixel was not found
EndFunc

; #FUNCTION# ==================================================================================================================================================
Func _FPGetAllPixelPosition($PixelNumber)
	$Array = DllStructCreate('dword['&$PixelNumber&']')
	$Result = DllCall($FP_Dll, 'int', 'GetPixelArr', 'ptr',  DllStructGetPtr($Array), 'int', $PixelNumber)
	If @error Or  $Result[0] == -1 Then Return SetError(1, 0, -1)
	If $Result[0] == 0 Then Return $Result[0]

	Local $aPosition[$Result[0]][2]
	For $i = 0 To $Result[0] - 1
		$Position = DllStructGetData($Array, 1, $i + 1)
		$aPosition[$i][0] = BitAND($Position, 0xFFFF)
		$aPosition[$i][1] = BitAND(BitShift($Position, 16), 0xFFFF)
	Next
	Return $aPosition ; Success: returns the array of pixel coordinates
EndFunc

; #FUNCTION# ==================================================================================================================================================
Func _FPGetImageHandle()
	$Result = DllCall($FP_Dll, 'int', 'ImageGetHandle')
	If @error Then Return SetError(1, 0, -1)

	Return '0x'&Hex($Result[0]) ; Success: returns handle
EndFunc

; #FUNCTION# ==================================================================================================================================================
Func _FPGetPixel($X, $Y)
	$Result = DllCall($FP_Dll, 'int', 'GetPixel_Buff', 'int', $X, 'int', $Y)
	If @error Or  $Result[0] == -1 Then Return SetError(1, 0, -1)

	Return '0x'&StringTrimLeft(Hex($Result[0]), 2) ; Success: returns pixel color
EndFunc

; #FUNCTION# ==================================================================================================================================================
Func _FPGetSearchMode()
	$Result = DllCall($FP_Dll, 'int', 'GetSearchMode')
	If @error Then	Return SetError(1, 0, -1)

	Return $Result[0] ; Success: returns search mode
EndFunc

; #FUNCTION# ==================================================================================================================================================
Func _FPLoadImage($FileName)
	$Result = DllCall($FP_Dll, 'int', 'ImageLoad', 'str', $FileName)
	If @error Or $Result[0] == 1 Then Return SetError(1, 0, -1)

	$Result[0] = -2
	Return $Result[0]; Success: returns "-2"
EndFunc

; #FUNCTION# ==================================================================================================================================================
Func _FPLoadImageByHandle($hBMP)
    $Result = DllCall($FP_Dll, 'int', 'ImageLoadHandle', 'handle', $hBMP)
	If @error Or $Result[0] == 0 Then Return SetError(1, 0, -1)

	$Result[0] = -2
	Return $Result[0]; Success: returns "-2"
EndFunc

; #FUNCTION# ==================================================================================================================================================
Func _FPSaveImage($FileName)
	$Result = DllCall($FP_Dll, 'int', 'ImageSave', 'str', $FileName)
	If @error Or $Result[0] == 0 Then Return SetError(1, 0, -1)

	$Result[0] = -2
	Return $Result[0]; Success: returns "-2"
EndFunc

; #FUNCTION# ==================================================================================================================================================
Func _FPSetSearchMode($Mode)
	If Not($Mode==0 Or  $Mode==1) Then Return SetError(1, 0, -1)
	DllCall($FP_Dll, 'int', 'SetSearchMode', 'int', $Mode)
	If @error Then	Return SetError(1, 0, -1)
EndFunc

; #FUNCTION# ==================================================================================================================================================
Func _FPTakeSnapshot($X0, $Y0, $Width, $Height, $hWnd)
	$Result = DllCall($FP_Dll, 'int', 'ScreenToBuff', 'int', $X0, 'int', $Y0, 'int', $Width, 'int', $Height, 'hWnd', $hWnd)
	If @error Or $Result[0] == 0 Then	Return SetError(1, 0, -1)

	Return '0x'&Hex($Result[0]) ; Success: returns image handle
EndFunc